﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;

namespace Notatnik.NET_2014
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        string ścieżkaPliku = "";

        private void otwórzToolStripMenuItem_Click(object sender, EventArgs e)
        {
            openFileDialog1.FileName = ścieżkaPliku;
            DialogResult dr = openFileDialog1.ShowDialog();
            if(dr == DialogResult.OK)
            {
                try
                {
                    //textBox1.Lines = PlikiTekstowe.CzytajPlikTekstowy(openFileDialog1.FileName);
                    textBox1.CzytajZPliku(openFileDialog1.FileName);
                    ścieżkaPliku = openFileDialog1.FileName;
                    toolStripStatusLabel1.Text = "Wczytano plik '" + Path.GetFileName(ścieżkaPliku) + "'";
                    statusStrip1.BackColor = Color.Green;
                    textBox1.ReadOnly = openFileDialog1.ReadOnlyChecked;
                }
                catch(Exception exc)
                {
                    toolStripStatusLabel1.Text = exc.Message;
                    statusStrip1.BackColor = Color.Red;
                }
            }
        }

        private void zapiszJakoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            saveFileDialog1.FileName = ścieżkaPliku;
            saveFileDialog1.FilterIndex = openFileDialog1.FilterIndex;
            saveFileDialog1.InitialDirectory = Path.GetDirectoryName(toolStripStatusLabel1.Text);
            saveFileDialog1.FileName = Path.GetFileName(toolStripStatusLabel1.Text);            
            DialogResult dr = saveFileDialog1.ShowDialog();
            if(dr == DialogResult.OK)
            {
                try
                {
                    PlikiTekstowe.ZapiszDoPlikuTekstowego(saveFileDialog1.FileName, textBox1.Lines);
                    ścieżkaPliku = saveFileDialog1.FileName;
                    toolStripStatusLabel1.Text = "Zapisano do pliku '" + Path.GetFileName(ścieżkaPliku) + "'";
                    statusStrip1.BackColor = Color.Green;
                }
                catch(Exception exc)
                {
                    toolStripStatusLabel1.Text = exc.Message;
                    statusStrip1.BackColor = Color.Red;
                }
            }
        }

        private void czcionkaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            fontDialog1.Font = textBox1.Font;
            fontDialog1.Color = textBox1.ForeColor;
            if(fontDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox1.Font = fontDialog1.Font;
                textBox1.ForeColor = fontDialog1.Color;
            }
        }

        private void kolorTłaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            colorDialog1.Color = textBox1.BackColor;
            if(colorDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox1.BackColor = colorDialog1.Color;
            }
        }

        private void pasekStanuToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //pasekStanuToolStripMenuItem.Checked = !pasekStanuToolStripMenuItem.Checked;
            statusStrip1.Visible = pasekStanuToolStripMenuItem.Checked;
        }
    }


    static class Rozszerzenia
    {
        public static bool CzytajZPliku(this TextBox textBox, string ścieżkaPliku)
        {
            try
            {
                textBox.Lines = PlikiTekstowe.CzytajPlikTekstowy(ścieżkaPliku);
                return true;
            }
            catch
            {
                return false;
            }
        }
    }
}
